'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './detailpage.less';
import { Button } from '@src/components/Button';
import { _asyncThrottle } from '@src/utils/utils';
import store from '@src/store';
import { PAGE_MAP } from '@src/utils/constants';


@observer
class Detailpage extends React.Component {
  constructor(props) {
    super(props);
  }

  back = _asyncThrottle(() => {
    store.changePage(PAGE_MAP.HOME_PAGE)
  })

  render() {
    return (
      <div className="detailpage modal_center">
        <span className="bg"></span>
        <Button className="back" onClick={this.back} />
        <div className="list">
          <span className="border"></span>
          <span className="l_bg"></span>
          {/* arrary */}
          <div className="sample">
            <span className="name">完成200分获得青果</span>
            <span className="time">2025.03.25</span>
            <span className="receive">+1000000000</span>
            <span className="line"></span>
          </div>
          
        </div>
        <span className="headline"></span>
      </div>
    );
  }
}
export default Detailpage;
