'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './successpop.less';
import modalStore from '@src/store/modal';
import { Button } from '../Button';
import BarItem from '../barItem/barItem';
import store from '@src/store';
import { PAGE_MAP } from '@src/utils/constants';

@observer
class Successpop extends React.Component {
  constructor(props) {
    super(props);
  }
  closePop() {
    store.changePage(PAGE_MAP.HOME_PAGE);
    modalStore.closePop("Successpop")
  }
  render() {
    return (
      <div className="successpop modal_center">
        <Button className="close" onClick={this.closePop}></Button>
        <span className="bg"></span>
        <div className="barbox">
          <span className="barbg"></span>
          {/* <span className="bar"></span> */}
          <BarItem left={-10} top={20} scaleNum={0.95} barInfo={store.homeInfo?.boxInfo} nowScore={this.props.popData.score}></BarItem>
        </div>
        <Button className="btn" onClick={this.closePop}></Button>
        <span className="score"><p>本次我赚了{this.props.popData.score}</p><p>获得{this.props.popData.sendCount}青果</p></span>
      </div>
    );
  }
}
export default Successpop;
