import MD from 'spark-utils/out/md/index.js';

import { logClick, logExposure } from "@spark/utils/src-js/md";

let appId = CFG.appID;
const dcm = '202.' + CFG.projectId + '.0.0';
const domain = '//embedlog.duiba.com.cn';

let MDList = [
  {
    ele: `.test-md1`,
    data: {
      dpm: `${appId}.110.5.1`,
      dcm,
      domain,
      appId
    },
    once: false
  }
];

export default () =>
  MD({
    show: MDList, // 曝光
    click: MDList // 点击
  });

export function handleLogExposure(id, id2 = 1) {
  logExposure({
    dpm: `${appId}.110.${id}.${id2}`,
    dcm,
    domain,
    appId,
  });
}
export function handleLogClick(id, id2 = 1) {
  logClick({
    dpm: `${appId}.110.${id}.${id2}`,
    dcm,
    domain,
    appId,
  });
}
