import React, { Component } from 'react';
import './guideModal.less';
import modalStore from '@src/store/modal';
import { _throttle } from '@src/utils/utils';
import { SvgaPlayer } from '@spark/svgaplayer';
import { RES_PATH } from '../../../sparkrc';

class GuideModal extends Component {

  state = {
    guideStep: 1
  }

  closeModal = _throttle(() => {
    const {handleStartSvga} = this.props.popData;
    handleStartSvga && handleStartSvga(true);
    modalStore.closePop("GuideModal")
  })

  guideStep = _throttle(() => {
    const {guideStep} = this.state;

    let newGuide = guideStep;

    if(newGuide >= 3) {
      this.closeModal();
      return
    }

    newGuide++;
    this.setState({
      guideStep: newGuide
    })

   
  }, 500)

  render() {
    const {guideStep} = this.state;

    return (
      <div className='guideModal' onClick={this.guideStep}>
        {guideStep == 1 && <>
          <div className="bg"></div>
          <SvgaPlayer className='hand' src={RES_PATH + "svga/4输出引导.svga"}/>
        </>}
        {guideStep > 1 && <img src={RES_PATH + `gamePage/guide${guideStep}.jpg`} className="guideImg" /> }
        
      </div>  
    );
  }
}

export default GuideModal;
