/**
 * 活动主入口
 */
import React, { Component } from "react";
import ReactDOM from "react-dom";
import { observer } from "mobx-react";
import "./app.less";
import store from "./store/index";
import Modal from "./modal/modal";
import "./utils/checkwebp"; // webp检查
import MD from "../MD"; // 埋点
MD();

// 此处为spark-cli动态生成
import Detailpage from "./pages/detailpage/detailpage";
import Rankpage from "./pages/rankpage/rankpage";
import { PAGE_MAP } from "./utils/constants";
import Loading from "./pages/loading/loading";
import Homepahe from "./pages/homepahe/homepahe";
import GamePage from "./pages/gamePage/gamePage";

/**
 * 所有页面场景
 */
const pageMap = {
  [PAGE_MAP.LOADING_PAGE]: <Loading />,
  [PAGE_MAP.HOME_PAGE]: <Homepahe />,
  [PAGE_MAP.DETAIL_PAGE]: <Detailpage />,
  [PAGE_MAP.RANK_PAGE]: <Rankpage />,
  [PAGE_MAP.GAME_PAGE]: <GamePage />,
};

@observer
class App extends Component {
  async componentDidMount() {
    // 获取前端开发配置，依据项目需要，酌情添加 ！！！
    await store.getFrontVariable();
    await store.doShare()
  }

  render() {
    const { curPage, pageData } = store;
    return (
      <>
        {{ ...pageMap[curPage], props: { ...pageData } }}
        <Modal />
      </>
    );
  }
}

ReactDOM.render(<App />, document.getElementById("root"));
