'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './barItem.less';
import modalStore from '@src/store/modal';
import store from '@src/store';
import { Button } from '../Button';

@observer
class BarItem extends React.Component {
  constructor(props) {
    super(props);
  }
  componentDidUpdate() {
    console.log(this.props,"!@!@!@!@!@!@")
  }

  render() {
    const { barInfo } = this.props;
    return (
      <div className="gamebar">
        <span className="bardown"></span>
        <span className="baron"></span>
        {
          barInfo?.map((item, index) => {
            return (
              <div key={"box" + index} className={"boxitem" + " box" + (index + 1)}>
                <span className={(item.receive ? 'open' : 'close') + (index + 1)}></span>
                <span className="score">{item.score}分</span>
                {
                  item.receive && <span className="prizebg"></span>
                }
                <span className="prize">{item.sendCount}青果</span>
              </div>     
            )
          })
        }
      </div>
    );
  }
}
export default BarItem;
