'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './rulepop.less';
import store from '@src/store';
import modalStore from '@src/store/modal';
import { Button } from '../Button';

@observer
class Rulepop extends React.Component {
  constructor(props) {
    super(props);
  }
  componentDidMount() {
    store.initRule()
  }
  closePop(){
    modalStore.closePop()
  }
  render() {
    return (
      <div className="rulepop modal_center">
        <Button className="close" onClick={this.closePop}></Button>
        <span className="bg"></span>
        <span className="ruletxt" dangerouslySetInnerHTML={{ __html: store.ruleInfo }}></span>
      </div>
    );
  }
}
export default Rulepop;
