'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './rankpage.less';
import { Button } from '@src/components/Button';
import { _asyncThrottle } from '@src/utils/utils';
import store from '@src/store';
import { PAGE_MAP } from '@src/utils/constants';
import API from '@src/api';

@observer
class Rankpage extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      info: {}
    }
  }

  componentDidMount() {
    this.getRank();
  }

  // 明细
  getRank = async () => {
    const { success, data } = await API.getRankInfo();
    if (success) {
      this.setState({
        info: data || {}
      })
    }
  }

  back = _asyncThrottle(() => {
    store.changePage(PAGE_MAP.HOME_PAGE)
  })

  render() {
    const { rankInfo = [], myRank = {} } = this.state?.info;
    const hasRankData = rankInfo.length > 0;
    return (
      <div className="rankpage md5">
        <span className="bg"></span>
        <span className="headnline"></span>
        <span className="tip">该成绩仅为游戏当日分数</span>
        <Button className="back" onClick={this.back} />
        <div className="list">
          <span className="listbg"></span>
          <div className="own">
            <span className="ownbg"></span>
            <span className="ownrank">
              {myRank.index === -1
                ? (myRank.score === 0 ? '—' : '100+')
                : myRank.index}
            </span>
            <span className="ownname">{myRank.userName || '口味王用户'}</span>
            <span className="ownscore">
              {myRank.index === -1 ? 0 : (myRank.score || 0)}
            </span>
          </div>
          {hasRankData ? (
            <>
              <div className="l_bg">
                {Array.isArray(rankInfo) && rankInfo.length > 0 &&
                  rankInfo.map((item) => (
                    <div className="sample" key={item.index}>
                      <span className="userrank">
                        {item.index === -1
                          ? '—'
                          : item.index > 100
                            ? '100+'
                            : item.index
                        }
                      </span>
                      <span className="username">{item.userName || '口味王用户'}</span>
                      <span className="userscore">
                        {item.index === -1 ? 0 : (item.score || 0)}
                      </span>
                      <span className="line"></span>
                    </div>
                  ))
                }
              </div>
            </>
          ) : <span className='nodata'>暂无数据</span>}
          <span className="rank">排名</span>
          <span className="name">用户昵称</span>
          <span className="score">获得分数</span>
        </div>
      </div>
    );
  }
}
export default Rankpage;
