'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './homepahe.less';
import modalStore from '@src/store/modal';
import { Button } from '@src/components/Button';
import store from '@src/store';
import { PAGE_MAP } from '@src/utils/constants';
import { Toast } from '@spark/ui';
import BarItem from '@src/components/barItem/barItem';
import { RES_PATH } from '../../../sparkrc';
import { SvgaPlayer } from '@spark/svgaplayer';

@observer
class Homepahe extends React.Component {
  constructor(props) {
    super(props);
  }
  componentDidMount() {
    store.getIndexInfo()
    let data = {
      boxId: 2,
      score: 600,
      sendCount: 500
    }
    // modalStore.pushPop("Failpop",data)
    // modalStore.pushPop("Successpop", data)
  }
  click_Rule() {
    if (!store.checkTime(false)) {
      return
    }
    modalStore.pushPop("Rulepop")
  }
  click_Rank() {
    if (!store.checkTime()) {
      return
    }
    store.changePage(PAGE_MAP.RANK_PAGE)
  }
  click_Detail() {
    if (!store.checkTime(false)) {
      return
    }
    store.changePage(PAGE_MAP.DETAIL_PAGE)
  }
  click_StartBtn() {
    if (!store.checkTime()) {
      return
    }
    // TODO 成长值没有
    if (!store.homeInfo.join) {
      Toast("成长值不足，无法参与游戏")
      return
    }
    store.startGame()
  }
  render() {
    return (
      <div className="homepahe modal_center">
        <span className="bg"></span>
        <SvgaPlayer className="show" src={RES_PATH + "svga/3输出首页氛围.svga"}></SvgaPlayer>
        {
          store.homeInfo.historyMaxScore != 0 &&
          <div className="infobox">
            <span className="infobg"></span>
            <span className="lab">我最高赚了{store.homeInfo.historyMaxScore || 0}</span>
          </div>
        }
        <span className="gamebarbg"></span>
        <BarItem left={88} top={361} scaleNum={1} barInfo={store.homeInfo?.boxInfo} nowScore={store.homeInfo.todayMaxScore}></BarItem>
        <SvgaPlayer className="startbtn" src={RES_PATH + "svga/1输出首页按钮.svga"} onClick={this.click_StartBtn}></SvgaPlayer>
        {/* <span className="title"></span> */}
        <Button className="rule" onClick={this.click_Rule}></Button>
        <Button className="rank" onClick={this.click_Rank}></Button>
        <Button className="detail" onClick={this.click_Detail}></Button>
      </div>
    );
  }
}
export default Homepahe;
