import { PAGE_MAP } from '@src/utils/constants';
import { makeAutoObservable } from 'mobx';
import API from '../api/index';
import { GetCurrSkinId, getCustomShareId } from "@src/utils/utils";
import { Toast } from '@spark/ui';
import modalStore from './modal';
import { AESDecrypt, AESEncrypt } from '@src/utils/Crypto';

const skinId = GetCurrSkinId() || getCustomShareId();

const store = makeAutoObservable({
  /** 活动规则 */
  ruleInfo: '',

  /** 前端开发配置 */
  frontVariable: {},

  /** 当前页面 */
  curPage: {
    // TODO 举例子，自定义页面，因为mng更新原因原数字id会对应一个新的字符串id
    "5055": "sharePage",
    Did1NDA0NDc: "sharePage",

    myPrize: "myPrize", // TODO 举例子 新宿台奖品页
    index: PAGE_MAP.LOADING_PAGE,
  }[skinId] || PAGE_MAP.HOME_PAGE,

  pageData: {},

  /** 场景切换 */
  changePage(page, data = {}) {
    this.pageData = data;
    this.curPage = page;
  },

  /** 获取活动规则 */
  async initRule() {
    // 模拟获取远程的数据
    const { data } = await API.getRule();
    this.ruleInfo = data;
  },

  /** 获取前端配置项 */
  async getFrontVariable() {
    // 获取前端开发配置
    const { data } = await API.getFrontVariable();
    this.frontVariable = data || {};
    console.log('前端开发配置', data)
  },
  timeStamp: '',
  homeInfo: {},
  async getIndexInfo() {
    const { success, data } = await API.indexInfo()
    if (success && data) {
      this.timeStamp = data.currentTimestamp
      this.homeInfo = data
    }
  },
  checkTime(checkEnd = true) {
    if (store.homeInfo?.actStartTimestamp > store.timeStamp) {
      Toasts("活动未开始")
      return false
    }
    if (checkEnd && store.homeInfo?.actEndTimestamp < store.timeStamp) {
      Toast("活动已结束")
      return false
    }
    return true
  },
  startInfo: {},
  async startGame() {
    this.submitFlag = false
    const { success, data } = await API.startGame()
    if (success) {
      if(location.href.indexOf('localhost') > -1) {
        this.startInfo = data
      } else {
        this.startInfo = JSON.parse(AESDecrypt(data, '3C8C48E792E9241B', 'cDOiBC1n2QrkAY2P'));
      }
      // TODO 游戏页面
      store.changePage(PAGE_MAP.GAME_PAGE)
    }
  },
  submitFlag: false,
  async submitScore(score) {

    if(this.submitFlag) return;
    this.submitFlag = true;

    const obj = {
      recordId: store.startInfo?.recordId,
      score,
      timestamp: Date.now(), // 毫秒数
    }
    const param = AESEncrypt(JSON.stringify(obj), '3C8C48E792E9241B', 'cDOiBC1n2QrkAY2P');

    const res = await API.submitGame({ 
      score,
      param
     })

    if(!res || !res.success || !res.data) return;

    if(res.data?.sendCount > 0) {
      modalStore.pushPop("Successpop", res.data)
    } else {
      modalStore.pushPop("Failpop", res.data)
    }
    // modalStore.pushPop("Successpop", data)
    // modalStore.pushPop("Failpop", data)
  }

})
export default store;
