'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './barItem.less';
import modalStore from '@src/store/modal';
import store from '@src/store';
import { Button } from '../Button';

const barPoint = [-451, -290, -126]
@observer
class BarItem extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      left: -486
    }
  }
  componentDidUpdate() {
    console.log(this.props, "!@!@!@!@!@!@")


  }
  updateLength() {
    const { barInfo, nowScore } = this.props;
    let left = 0;
    if (barInfo && barInfo.length > 0) {
      if (nowScore <= barInfo[0].score) {
        left = -486
      } else if (barInfo[3].score <= nowScore) {
        left = 0
      } else {
        for (let i = 0; i < barInfo.length; i++) {
          if (nowScore <= barInfo[i].score) {
            let num = nowScore - barInfo[i - 1].score
            let length = barInfo[i].score - barInfo[i - 1].score
            console.log(i, barInfo[i - 1].score, num, length, "left", "num,length")
            left = barPoint[i - 1] + num / length * (i == 3 ? 100 : 113)
            break
          }
        }
      }
      console.log(left, "left")
      return left
    }
  }

  render() {
    const { barInfo, left, top, scaleNum } = this.props;
    return (
      <div className="gamebar" style={{ left: left / 100 + "rem", top: top / 100 + "rem", transform: `scale(${scaleNum})` }}>
        <span className="bardown"></span>
        <div className='barbox'>
          <span className="baron" style={{
            left: this.updateLength() / 100 + "rem"
          }}></span>
        </div>
        {
          barInfo?.map((item, index) => {
            return (
              <div key={"box" + index} className={"boxitem" + " box" + (index + 1)}>
                <span className={(item.receive ? 'open' : 'close') + (index + 1)}></span>
                <span className="score">{item.score}分</span>
                {
                  item.receive && <span className="prizebg"></span>
                }
                <span className="prize">{item.sendCount}青果</span>
              </div>
            )
          })
        }
      </div>
    );
  }
}
export default BarItem;
