'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './failpop.less';
import modalStore from '@src/store/modal';
import store from '@src/store';
import { Button } from '../Button';
import { PAGE_MAP } from '@src/utils/constants';

@observer
class Failpop extends React.Component {
  constructor(props) {
    super(props);
  }
  closePop() {
    store.changePage(PAGE_MAP.HOME_PAGE);
    modalStore.closePop()
  }
  async restartGame() {
    store.changePage(PAGE_MAP.HOME_PAGE);
    await store.startGame();
    modalStore.closePop()
  }
  render() {
    return (
      <div className="failpop modal_center md4">
        <span className="bg"></span>
        <Button className="close" onClick={this.closePop}></Button>
        <span className="lab">本次我赚了{this.props.popData.score}</span>
        <Button className="goonbtn" onClick={this.restartGame}></Button>
        <Button className="endbtn" onClick={this.closePop}></Button>
      </div>
    );
  }
}
export default Failpop;
