'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './detailpage.less';
import { Button } from '@src/components/Button';
import { _asyncThrottle, dateFormatter } from '@src/utils/utils';
import store from '@src/store';
import { PAGE_MAP } from '@src/utils/constants';
import API from '@src/api';


@observer
class Detailpage extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      detailInfo: {}
    }
  }

  componentDidMount() {
    this.getDetail();
  }

  // 明细
  getDetail = async() => {
    const { success, data } = await API.getQGDetails();
    if (success) {
      this.setState({
        detailInfo: data || {}
      })
    }
  }

  back = _asyncThrottle(() => {
    store.changePage(PAGE_MAP.HOME_PAGE)
  })

  render() {
    const list = this.state.detailInfo.list || [];
    return (
      <div className="detailpage modal_center">
        <span className="bg"></span>
        <Button className="back" onClick={this.back} />
        <div className="list">
          <span className="border"></span>
          <span className="l_bg"></span>
          {Array.isArray(list) && list.length > 0 ? list.map((item, index) => {
            const{ changedType, quantity, createTimestamp } = item;
            return (
              <div className="sample" key={index}>
                <span className="name">完成{quantity}分获得青果</span>
                <span className="time">{dateFormatter(createTimestamp, "yyyy-MM-dd")}</span>
                <span className="receive">+1000000000</span>
                <span className="line"></span>
              </div>
            )
          }) : null}

        </div>
        <span className="headline"></span>
      </div>
    );
  }
}
export default Detailpage;
