'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './detailpage.less';
import { Button } from '@src/components/Button';
import { _asyncThrottle, dateFormatter } from '@src/utils/utils';
import store from '@src/store';
import { PAGE_MAP } from '@src/utils/constants';
import API from '@src/api';


@observer
class Detailpage extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      logList: [],        // 列表数据
      isSearching: false // 是否在请求列表中
    }
    this.pageNum = 1; // 页码
    this.pageSize = 10; // 每页条数
    this.isLoadedAll = false; // 是否加载完所有数据
  }

  componentDidMount() {
    this.getDetail();
  }

  // 明细 获取列表数据
  getDetail = async () => {
    if (this.state.isSearching) return;
    if (this.isLoadedAll) return;
    this.setState({ isSearching: true })
    const params = {
      pageNum: this.pageNum, // 页数，默认1
      pageSize: this.pageSize, // 查询数量，默认10
    }

    const { success, data } = await API.getQGDetails(params);
    if (success) {
      const _list = this.state.logList.concat(data?.list || [])
      this.setState({
        isSearching: false,
        logList: _list,
      });
      this.isLoadedAll = !data?.haveMore
      this.pageNum++;
    }
  }

  // 监听滚动事件
  handScroll = (e) => {
    if (
      e.target.scrollTop + e.target.clientHeight + 10 >=
      e.target.scrollHeight
    ) {
      this.getDetail();
    }
  };


  back = _asyncThrottle(() => {
    store.changePage(PAGE_MAP.HOME_PAGE)
  })

  render() {
    const { logList } = this.state;
    return (
      <div className="detailpage" onScroll={this.handScroll}>
        <span className="bg"></span>
        <Button className="back" onClick={this.back} />
        <div className="list">
          <span className="listbg"></span>
          <div className="l_bg">
            {Array.isArray(logList) && logList.length > 0 ? logList.map((item, index) => {
              const { changedType, quantity, extra, gmtCreate } = item;
              return (
                <div className="sample" key={index}>
                  <span className="name">{extra}</span>
                  <span className="time">{dateFormatter(gmtCreate, "yyyy-MM-dd")}</span>
                  <span className="receive">{changedType}{quantity}</span>
                  {index != logList.length - 1 && <span className="line"></span>}
                </div>
              )
            }) : <span className="nodata">暂无数据</span>}
          </div>
        </div>
        <span className="headline"></span>
      </div>
    );
  }
}
export default Detailpage;
