import React, { Component } from 'react';
import './guideModal.less';
import modalStore from '@src/store/modal';
import { _throttle } from '@src/utils/utils';
import { SvgaPlayer } from '@spark/svgaplayer';
import { RES_PATH } from '../../../sparkrc';

class GuideModal extends Component {

  closeModal = _throttle(() => {
    const {handleStartSvga} = this.props.popData;
    handleStartSvga && handleStartSvga(true);
    modalStore.closePop("GuideModal")
  })

  render() {
    return (
      <div className='guideModal' onClick={this.closeModal}>
        <div className="bg"></div>
        <SvgaPlayer className='hand' src={RES_PATH + "svga/4输出引导.svga"}/>
      </div>
    );
  }
}

export default GuideModal;
