'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './homepahe.less';
import modalStore from '@src/store/modal';
import { Button } from '@src/components/Button';
import store from '@src/store';
import { PAGE_MAP } from '@src/utils/constants';
import { Toast } from '@spark/ui';
import BarItem from '@src/components/barItem/barItem';

@observer
class Homepahe extends React.Component {
  constructor(props) {
    super(props);
  }
  componentDidMount() {
    store.getIndexInfo()
  }
  click_Rule() {
    if (!store.checkTime(false)) {
      return
    }
    modalStore.pushPop("Rulepop")
  }
  click_Rank() {
    if (!store.checkTime()) {
      return
    }
    store.changePage(PAGE_MAP.RANK_PAGE)
  }
  click_Detail() {
    if (!store.checkTime(false)) {
      return
    }
    store.changePage(PAGE_MAP.DETAIL_PAGE)
  }
  click_StartBtn() {
    if (!store.checkTime()) {
      return
    }
    // TODO 成长值没有
    // if(store.userInfo.growthValue < 100){
    // Toast("成长值不足，无法参与游戏")
    // }
    store.startGame()
  }
  render() {
    return (
      <div className="homepahe modal_center">
        <span className="bg"></span>
        <span className="show"></span>
        {
          store.homeInfo.historyMaxScore != 0 &&
          <div className="infobox">
            <span className="infobg"></span>
            <span className="lab">我最高赚了{store.homeInfo.historyMaxScore || 0}</span>
          </div>
        }
        <span className="gamebarbg"></span>
        <BarItem barInfo={store.homeInfo?.boxInfo} nowScore={store.homeInfo.historyMaxScore}></BarItem>
        <Button className="startbtn" onClick={this.click_StartBtn}></Button>
        <span className="title"></span>
        <Button className="rule" onClick={this.click_Rule}></Button>
        <Button className="rank" onClick={this.click_Rank}></Button>
        <Button className="detail" onClick={this.click_Detail}></Button>
      </div>
    );
  }
}
export default Homepahe;
