'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './firstPop.less';
import { ModalCtrl } from '@/core/ctrls/ModalCtrl';
import { Button, Toast } from '@grace/ui';
import { _asyncThrottle, formatThousand } from '@/utils/utils';

/* 电话号码验证规则 **/
export const REG_TEL = /^1[0-9]{10}$/;

@observer
class FirstPop extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      privacyChecked: false
    }
  }

  // 确认提交  
  handleSubmit = _asyncThrottle(() => {
    const { notifyText } = this.props || {};

    if (!!notifyText && !this.state.privacyChecked) {  // 未勾选隐私协议
      Toast.show(`请先勾选${notifyText}`)
      return false
    }
    ModalCtrl.closeModal()
  })

  close = () => {
    ModalCtrl.closeModal()
  }

  render() {
    const { privacyChecked } = this.state;

    const { experienceNum, notifyText } = this.props || {};
    return (<>
      <div className="firstPop modal_center">
        <span className="bg"></span>
        <span className="title">理财体验金</span>
        <div className="amount">{formatThousand(experienceNum)}<span className="unit">元</span></div>
        {!!notifyText && <div className="check_box">
          <div className={`check_icon ${privacyChecked ? 'checked' : ''}`} onClick={() => this.setState({ privacyChecked: !this.state.privacyChecked })}></div>
          <div className="check_text">{notifyText}</div>
        </div>}
        <Button className="happy_btn md2" onClick={this.handleSubmit}></Button>
        <Button className="close" onClick={this.close}></Button>
      </div>
    </>);
  }
}
export default FirstPop;
