import React from 'react';
import { observer } from 'mobx-react';
import './productListPage.less';
import { Button } from "@grace/ui";
import { PageCtrl } from "@/core/ctrls/PageCtrl.tsx";
import HomePage from "@/pages/HomePage/HomePage.tsx";
import store from '@/store/store';
import { diffJump, RATE_NAME } from '@/AppTools';
import JumpConfirmPop from '@/panels/jumpConfirmPop/jumpConfirmPop.jsx';
import { ModalCtrl } from '@/core/ctrls/ModalCtrl';

@observer
class ProductListPage extends React.Component<any, any> {

    state = {
    }

    /** 跳转“真实”产品详情页 */
    jumpRealDetailHandle = (item) => {
        ModalCtrl.showModal(JumpConfirmPop, {
            confirmCb: () => {
                diffJump(item.realBuyJumpUrl)
            }
        })
    }

    clickBack = () => {
        PageCtrl.changePage(HomePage);
    }

    render() {
        const { recommendProductConfig } = store.indexData

        return <div className="productListPage">
            <div className="pageTitle" />
            <Button className="backBtn" onClick={this.clickBack} />
            <div className="list_bg"></div>
            {recommendProductConfig?.length
                ? <div className="products_list">
                    {recommendProductConfig?.map((item, index) => (
                        <div className="product_item" key={`r_prdct_${index}`} onClick={() => this.jumpRealDetailHandle(item.realBuyJumpUrl)}>
                            <span className="product_name">{item.name}</span>
                            <div className="product_rate">
                                {!!item.rate && <span className="product_rate_value">{(item.rate / 100).toFixed(2)}%</span>}
                                <span className="product_rate_label">{RATE_NAME[item.type] || '年化收益率'}</span>
                            </div>
                            <div className="product_shu">
                                <span className="product_shu_value">{item.shenShuGuiZei}</span>
                                <span className="product_shu_label">{item.fengXian} ｜ {item.qigouText}</span>
                            </div>
                            <Button className="real_btn"></Button>
                            <span className="product_line"></span>
                        </div>
                    ))}
                </div>
                : <div className="listNone">暂无产品哦</div>
            }
        </div>;
    }
}

export default ProductListPage;
