# 红包雨

## 导出

```typescript
enum GAME_EVENT {
	READY = "READY",    // 初始化完成
	START_GAME = "START_GAME",
	END_GAME = "END_GAME",
	ADD_SCORE = "ADD_SCORE", // 分辨增加
	ON_SHOW = 'ON_SHOW', // 页面显示
	ON_HIDE = 'ON_HIDE', // 页面隐藏
}

interface IConfig {
	dropSpeed?: number, // 掉落速度(px/s)
	interval?: number,  // 掉落间隔事件(s)
	rainObj?: string,   // 掉落物图片
}

// 设置参数
function setConfig(obj: IConfig) {
	/* ... */
};
```


## 作为模块使用

将项目源代码粘入你的项目中，修改当前项目的package.json中的`useAsModule`改为true，在根项目的package.json中修改/添加以下内容

```text
    
    "workspaces": [
        "src/game_module" // 修改为你的模块路径
    ],
    
    "scripts": {
        "dev": "cross-env NODE_ENV=development node ./config/scripts/assets/generateAssetList.js && concurrently \"cd ./src/game_module && yarn dev\" \"node ./config/webpack.dev.config.js\"",
        "prod:game": "cd ./src/game_module && yarn build",
        "prod:main": "cross-env NODE_ENV=production node ./config/webpack.prod.config.js",
        "prod:all": "cross-env NODE_ENV=production yarn prod:game && node ./config/webpack.prod.config.js",
        "build": "cross-env NODE_ENV=production yarn prod:game && node ./config/scripts/assets/generateAssetList.js && node ./config/scripts/assets/index.js imgmin imgup && node ./config/webpack.prod.config.js"
    },
```


## 使用案例

```jsx
import React, { Component } from 'react';

import { Game, setConfig, GDispatcher, GAME_EVENT } from "../../../debug/output.module";

import './GamePage.less';

export default class GamePage extends Component {
	
	div = null;
	game = null;
	
	componentDidMount() {
		const canvas = document.createElement("canvas");
		canvas.style = "width:100%;height:100%";
		this.div.appendChild(canvas);
		this.game = new Game(canvas);
		
		// 注册触摸事件
		this.game.initWebEvent();
		
		// 设置参数
		setConfig({
			dropSpeed: 750,
			interval: 0.05,
		});
		
		// 等待READY事件表示可以开始游戏
		GDispatcher.once(GAME_EVENT.READY, () => {
			// 触发开始游戏事件
			GDispatcher.dispatchEvent(GAME_EVENT.START_GAME);
		});
	}
	
	componentWillUnmount() {
		this.game.destroy();
	}
	
	render() {
		return <div
			className="game-page"
			ref={(div) => this.div = div}
		/>;
	}
}
```

