import { makeAutoObservable, } from 'mobx';
import API from "@/api";

class ResStore {

    constructor() {
        makeAutoObservable(this);
    }


    info = {
      titleImg: "",
      interval: "",
      amount: 0,
      profit: 0,
      cycle: "",
      remainDrawTime: 0,
        drawEndTime: 0,
      prizeInfo: [],
        cycleStartTime: 0,
        cycleEndTime: 0,
    };

    prizeList = [];

    async updatePrizeList() {
        const { success, data } = await API.records({
            ignoreSp: true,
        });
        if (!success) return;
        this.prizeList = data;
    }

    async updateInfo() {
        this.updatePrizeList();
        const { success, data } = await API.drawIndex();
        if (!success) return;
        this.info = data;
    }

}

export default (new ResStore());
