'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './sharepop.less';
import { ModalCtrl } from '@/core/ctrls/ModalCtrl';
import shareStore from '@/store/share';
import { _throttle } from '@/utils/utils';
import { Toast } from '@grace/ui';
import { copyToClipboard } from '@spark/utils';

@observer
class Sharepop extends React.Component {
  constructor(props) {
    super(props);
  }
  componentDidMount() {
    shareStore.getShareLink(true);
  }

  copyHandle = _throttle(() => {
    copyToClipboard(shareStore.inviteUrl);
    setTimeout(() => {
      copyToClipboard(shareStore.inviteUrl);
    }, 200)
    Toast.show("邀请链接已复制，快去微信打开吧")
  })

  close = () => {
    ModalCtrl.closeModal()
  }

  render() {
    return (
      <div className="sharepop modal_center">
        <span className="close" onClick={this.close}></span>
        <span className="bg"></span>
        <div className="copy_btn" onClick={this.copyHandle}></div>
        <span className="tips">将已复制链接发送好友,好友微信打开链接即可点赞助力</span>
      </div>
    );
  }
}
export default Sharepop;
