'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './index.less';
import store from '../../store/store';
import { Button } from '@grace/ui';
import { _asyncThrottle } from "../../utils/utils";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl";
import API from '@/api';

@observer
class AnswerPrizePanel extends React.Component {
  constructor(props) {
    super(props);

  }

  handleClose = _asyncThrottle(() => {
    ModalCtrl.closeModal()
  })

  render() {
    const { optionName, optionImg } = this.props
    return (
      <div className="answerPrizePanel modal_center">
        <span className="bg"></span>
        <div className='prizeimg-con'>
          <img className='prizeimg' src={optionImg}></img>
        </div>
        <div className='prize-name'>{optionName}</div>
        <div className='receive md29' onClick={this.handleClose} ></div>
        {/* <div className='tip'></div> */}
        <Button className="close" onClick={this.handleClose} />
      </div>
    );
  }
}
export default AnswerPrizePanel;
