/**
 * rollup.prod.mjs
 * Created by 还有醋v on 2022/9/19 下午6:10.
 * Copyright © 2022 haiyoucuv. All rights reserved.
 */

import json from "@rollup/plugin-json";
import resolve from "@rollup/plugin-node-resolve";
import typescript from "@rollup/plugin-typescript";
import fs from "fs";
import commonjs from "rollup-plugin-commonjs";
import glslLoader from "rollup-plugin-glsl-loader";
import progress from "rollup-plugin-progress";
import { terser } from "rollup-plugin-terser";
import BannerVariable from "./config/plugins/BannerVariable/index.mjs";
import babel from "@rollup/plugin-babel";
// import obfuscatorPlugin from './config/plugins/rollup-plugin-javascript-obfuscator.mjs'

const { version } = JSON.parse(fs.readFileSync("./package.json", "utf-8"));

export default {
	input: "src/index.ts",
	output: [
		{
			file: "released/output.js",
			format: "umd",
			name: "output",
			sourcemap: true,
		},
		{
			file: 'released/output.module.js',
			format: 'esm',
			sourcemap: true,
		}
	],
	plugins: [
		progress(),
		BannerVariable({
			values: {
				__ENV__: JSON.stringify(process.env.NODE_ENV || 'prod'),
				__version__: JSON.stringify(version),
				__buildDate__: JSON.stringify(new Date()),
				process: JSON.stringify({ env: { RUNTIME: "web" } })

			}
		}),
		babel.babel({
			exclude: "node_modules/**",
			presets: [
				[
					"@babel/preset-env",
					{
						modules: false,
						useBuiltIns: "usage",
					}
				]
			],
			babelHelpers: "runtime"
		}),
		resolve({ jsnext: true, preferBuiltins: true, browser: true }),
		commonjs(),
		typescript({ tsconfig: "./tsconfig.json", sourceMap: false, watch: false, }),
		json(),
		glslLoader({
			glslify: true,
		}),
		terser(),
		// obfuscatorPlugin({
		// 	// 疯狂debug
		// 	debugProtection: true,
		// 	debugProtectionInterval: 4000,
		//
		// 	// 单行输出
		// 	compact: true,
		//
		// 	// 自卫模式，美化代码就无法运行
		// 	selfDefending: true,
		//
		// 	// 扁平化控制流
		// 	controlFlowFlattening: true,
		// 	controlFlowFlatteningThreshold: 0.3,
		//
		// 	// 注入死代码
		// 	deadCodeInjection: true,
		// 	deadCodeInjectionThreshold: 0.2,
		//
		// 	// 标识符名称生成器
		// 	// hexadecimal			16进制 包体增大较多
		// 	// mangled				短名称
		// 	// mangled-shuffled		与mangled相同，但带有洗牌字母表
		// 	identifierNamesGenerator: 'mangled-shuffled',
		//
		// 	// 数字转表达式 如:
		// 	// const foo = 1234;
		// 	// const foo=-0xd93+-0x10b4+0x41*0x67+0x84e*0x3+-0xff8;
		// 	// numbersToExpressions: true,
		//
		// 	log: true,
		//
		// 	// 拆分字面字符串
		// 	splitStrings: true,
		//
		// 	stringArray: true,
		// 	rotateStringArray: true,
		// 	stringArrayCallsTransform: true,
		// 	stringArrayCallsTransformThreshold: 1,
		// 	stringArrayThreshold: 1,
		// 	stringArrayEncoding: ["none", "base64"],
		// 	stringArrayWrappersParametersMaxCount: 5,
		//
		// 	// transformObjectKeys: true,
		// 	target: "browser",
		// }),
	]
};
