import { destroyWaiting } from "./waitingCtrl";
import PanelCtrl from "./panelCtrl";
import SceneCtrl from "./sceneCtrl";
import { destroyToast } from "./toastCtrl";
import ConfirmPanel from "../../src/common/IConfirmPanel";

export { showToast } from "./toastCtrl";

export * from "./waitingCtrl";
/**
 * 展示弹框
 * @param panel 弹框类
 * @param data 数据
 */
export const showPanel = (panel: any, data?: any) => {
    return PanelCtrl.instance.show(panel, data)
}

export const showConfirm = (panel: any, data?: any) => {
    const confirmPanel: ConfirmPanel = PanelCtrl.instance.show(panel, data);
    return confirmPanel.makePromise();
}


/**
 * 关闭所有弹框
 */
export const closeAllPanels = () => {
    PanelCtrl.instance.closeAll();
}

/**
 * 关闭当前弹框
 */
export const closeCurrentPanel = () => {
    PanelCtrl.instance.closeCurrent();
}

/**
 * 替换场景
 * @param scene
 * @param data
 */
export const changeScene = (scene: any, data?: any) => {
    SceneCtrl.instance.change(scene, data)
}

/**
 * 获取当前场景
 */
export function getCurrentScene(): any {
    return SceneCtrl.instance.currentScene
}

/**
 * 获取当前弹框
 */
export function getCurrentPanel(): any {
  return PanelCtrl.instance.currentPanel
}

/**
 * 淘宝小程序的alert
 * @param {string} title
 * @param {string} content
 */
export const showAlert = (title?: string, content?: string) => {
    //@ts-ignore
    if (my) {
        //@ts-ignore
        my.alert({
            title: title || "",
            content: content || ""
        });
    } else {
        console.log(title, content)
    }

}

/**
 * 替换setTimeout  因为页面销毁时setTimeout不会停
 * 所以干脆用Tween的
 * @param {Function} callback
 * @param {number} time 毫秒计
 */
export function wait(callback: () => void, time: number): {} {
    let obj = {};
    FYGE.Tween.get(obj)
        .wait(time)
        .call(callback)
    return obj
}

export function clearWait(obj: {}) {
    obj && FYGE.Tween.removeTweens(obj);
}

/**
 * 递归清除显示对象里面所有的Tween
 * @param obj
 * @param isRecursive 默认true,递归移除子级
 */
export function removeTweens(obj, isRecursive: boolean = true) {
    if (!obj) return
    FYGE.Tween.removeTweens(obj);
    if (!isRecursive || !obj.children || !obj.children.length) return
    obj.children.forEach(child => {
        removeTweens(child)
    });
}

/**
 * 销毁方法
 */
export function destroyAllCtrls() {
    destroyToast();
    destroyWaiting();
    PanelCtrl.instance.destroy();
    SceneCtrl.instance.destroy();
}
