'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './signCom.less';
import { ModalCtrl } from '@/core/ctrls/ModalCtrl';
import { Button, Toast } from '@grace/ui';
import { _asyncThrottle, formatThousand } from '@/utils/utils';
import store from '@/store/store';
import API from '@/api';
import TaskPanel from '@/panels/taskPanel/index.jsx';
@observer
class SignCom extends React.Component {
  constructor(props) {
    super(props);
  }
  /** 已签到 */
  signedHandle = _asyncThrottle(async () => {
    if (!store.judgeActTime()) return
    Toast.show("今日已签到")
  })

  /** 签到 */
  signHandle = _asyncThrottle(async () => {
    if (!store.judgeActTime()) return
    const { success } = await API.doCheckIn();
    if (success) {
      Toast.show("签到成功")
    }
    await store.updateIndex();
  })
  /** 签到-领奖 */
  signPrizeHandle = _asyncThrottle(async (item) => {
    // 已领奖
    if (item.status) return false

    // 未签到
    const { checkIn } = store.indexData
    if (item.days > checkIn?.totalCheckIn) return false

    if (!store.judgeActTime()) return
    const { endPoint, currentTime } = store.indexData || {}
    if (endPoint <= currentTime) {
      Toast.show("模拟理财已结束～")
      return false
    }
    const { success } = await API.doRewards({ checkInConfigId: item.id });
    if (success) {
      Toast.show("领取成功")
    }
    await store.updateIndex();
  })
  render() {
    const { checkIn } = store.indexData
    return (
      <div className="task_sign_section">
        <span className="sign_section_bg"></span>
        <span className="sign_tips">最高可得{((checkIn?.totalExperienceNum || 0) / 10000).toFixed(0)}万理财体验金</span>
        {checkIn?.todayCheckIn
          ? <Button className="signed_btn" onClick={this.signedHandle}></Button>
          : <Button className="sign_btn" onClick={this.signHandle}></Button>
        }
        <div className="sign_progress">
          <span className="progress_bg"></span>
          <div className="progress_bar_box">
            <div className="progress_bar" style={{ width: `${store.percent}%` }}></div>
          </div>
          {checkIn?.checkInConfig?.map((item, index) => {
            return (
              <div
                className={`step_item step_item${index + 1} ${item.days > checkIn?.totalCheckIn ? 'locked' : item.status ? 'received' : 'signed'}`}
                key={`sign_${index}`}
                onClick={() => this.signPrizeHandle(item)}
              >
                <span className="prize_bg"></span>
                <div className="prize_amount">{((item.experienceNum || 0) / 10000).toFixed(0)}<span className="unit">万</span></div>
                <span className="prize_day">累计{item.days}天</span>
              </div>
            )
          })}
        </div>
      </div>
    );
  }
}
export default SignCom;
