import { Scene } from "../../module/views/Scene";
import Clock from "../tools/Clock";
import gameConfig from "../Config";
import { GAME_EVENT, GDispatcher } from "../index";
import RainObj from "./RainObj";
import UI from "../tools/UI";
import { RES } from "../../module/RES";
import Event = FYGE.Event;
import Container = FYGE.Container;
import SvgaAni = FYGE.SvgaAni;

export class GameScene extends Scene {

  get groupNames(): string[] {
    return ['game'];
  }

  clock: Clock = new Clock();

  /**
   * 是否暂停游戏
   * @type {boolean} true 暂停   false 不暂停
   */
  isPause: boolean = true;

  /**
   * 经过了多少时间
   * @type {number}
   */
  eTime: number = 0;

  objList: RainObj[] = [];

  // 掉落物层
  objCtn: Container;

  // 特效层
  effectCtn: Container;

  initUi() {
		this.objCtn = UI.Ctn(this);
		this.effectCtn = UI.Ctn(this);
		this.effectCtn.mouseEnable = this.effectCtn.mouseChildren = false;
	}

	async start(data?: any) {
		super.start(data);
		GDispatcher.dispatchEvent(GAME_EVENT.READY);
	}

	/**
	 * 添加特效
	 * @param x
	 * @param y
	 */
	addEffect(x, y, name) {
		const svga = {
			"红包1.png": "4点击反馈.svga",
			"红包2.png": "4点击反馈.svga",
			"红包3.png": "4点击反馈.svga",
			"金币.png": "4点击反馈.svga",
      "fudai.png": "4点击反馈.svga",
		}[name] || "4点击反馈.svga";
		const boomEffect = this.effectCtn.addChild(new SvgaAni(RES.getRes(svga)));
		const { videoWidth, videoHeight, totalFrames } = boomEffect;
		boomEffect.position.set(x - videoWidth / 2, y - videoHeight / 2);
		boomEffect.startAniRange(0, totalFrames, 1, () => {
			this.effectCtn.removeChild(boomEffect);
		});
	}

	/**
	 * 添加掉落物
	 */
	addObj() {
		const obj = RainObj.get();
		obj.reset();
		this.objCtn.addChild(obj);
		this.objList.push(obj);
	}

	/**
	 * 删除掉落物
	 */
	removeObj(obj) {
		this.objList.splice(this.objList.indexOf(obj), 1);
		this.objCtn.removeChild(obj);
		RainObj.put(obj);
	}

	initEvents() {
		super.initEvents();
		GDispatcher.addEventListener(GAME_EVENT.START_GAME, this.startGame, this);
		GDispatcher.addEventListener(GAME_EVENT.END_GAME, this.endGame, this);

		this.addEventListener(Event.ENTER_FRAME, this.onUpdate, this);
	}

	removeEvents() {
		super.removeEvents();
		GDispatcher.removeEventListener(GAME_EVENT.START_GAME, this.startGame, this);
		GDispatcher.removeEventListener(GAME_EVENT.END_GAME, this.endGame, this);

		this.removeEventListener(Event.ENTER_FRAME, this.onUpdate, this);
	}

	startGame() {
		// 已经开始了
		if (!this.isPause) return console.warn("已经开始了");

		this.isPause = false;
		this.eTime = 0;
	}

	endGame() {
    if (this.isPause) return console.warn("已经结束了");

    this.objList.forEach((obj) => {
      this.removeObj(obj);
    });
    this.objList.length = 0;
    this.objCtn.removeAllChildren();
    this.isPause = true;
  }

	onUpdate() {
		// 暂停
		if (this.isPause) return;

		const { interval, dropSpeed } = gameConfig;
		const { objList, clock } = this;

		let dt = clock.getDelta();
		if (dt > 0.067) dt = 0.067;

		this.eTime += dt;

		if (this.eTime > interval) {
			this.eTime = interval - this.eTime;
			this.addObj();
		}

		for (let i = objList.length - 1; i >= 0; i--) {
			const obj = objList[i];
			obj.y += dropSpeed * dt;
			if (obj.y > 1724) {
				this.removeObj(obj);
			}
		}
	}
}
