'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './tipspop.less';
import API from '@/api';
import { ModalCtrl } from '@/core/ctrls/ModalCtrl';
import { Button } from '@grace/ui';
import store from '@/store/store';
import { dateFormatter } from '@/utils/utils';
import QRCode from 'qrcode';

@observer
class Tipspop extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      qrcode: '', //二维码
    }
  }

  async componentDidMount() {
    await this.getCode()
  }


  /** 获取二维码 */
  async getCode() {
    const data = await QRCode.toDataURL(CFG.prizePageQrcodeUrl);
    // const { success, data } = await API.getQrcode({
    //   content: CFG.prizePageQrcodeUrl,
    //   width: 150,
    //   height: 150,
    //   domain: encodeURIComponent('https://90548-activity.dexfu.cn'),
    // })
    // if (success) {
      this.setState({
        qrcode: data || ''
      })
    // }
  }

  /** 关闭 */
  closeHandle = () => {
    ModalCtrl.closeModal()
  }

  render() {
    const { actEndTime } = store.indexData || {}
    return (
      <div className="tipspop modal_center">
        <span className="bg"></span>
        <div className="text">本期活动将于<span className="date">{dateFormatter(actEndTime, 'MM月dd日')}</span>结束，请您及时兑换背包内立减金权益，做好兑奖规划！</div>
        <div className="tips">可截图保存下方二维码，活动结束后扫码兑换权益</div>
        <div className="code_bg">
          <img className="code_img" src={this.state.qrcode} alt="" />
        </div>
        <Button className="btn" onClick={this.closeHandle}></Button>
        <Button className="close" onClick={this.closeHandle}></Button>
      </div>
    );
  }
}
export default Tipspop;
