import React from 'react';
import { observer } from 'mobx-react';
import styles from './ResPage.module.less';
import { Button } from "@grace/ui";
import classNames from "classnames";

@observer
class ResPage extends React.Component<any, any> {

    state = {
        tab: 1,
    }

    async componentDidMount() {

    }

    clickBack = () => {

    }

    changeTab = (tab) => {
        this.setState({ tab, });
    }

    render() {
        const { tab } = this.state;

        const tabCls = classNames(styles.tab, {
            [styles.tab1]: tab === 1,
            [styles.tab2]: tab === 2,
        });

        return <div className={styles.ResPage}>
            <div className={styles.bg}/>
            <div className={styles.rankBg}>
                <div className={styles.rankImg}/>
                <div className={classNames(styles.rankTip, styles.rank1)}>
                    我的收益区间在<span>3000元及以上</span>
                </div>
                <div className={classNames(styles.rankTip, styles.rank2)}>
                    理财资金<span>334556675元</span>
                </div>
                <div className={classNames(styles.rankTip, styles.rank3)}>
                    累计收益<span>2213元</span>
                </div>
                <div className={classNames(styles.rankTip, styles.rank4)}>
                    理财周期<span>2025.06.22-2025.07.22</span>
                </div>
            </div>
            <div className={tabCls}>
                <div className={styles.tabBtn1} onClick={() => this.changeTab(1)}/>
                <div className={styles.tabBtn2} onClick={() => this.changeTab(2)}/>


            </div>
            <Button className={styles.backBtn} onClick={this.clickBack}/>
        </div>;
    }
}

export default ResPage;
