import React from 'react';
import { observer } from 'mobx-react';
import styles from './ResPage.module.less';
import { Button } from "@grace/ui";
import classNames from "classnames";
import TurnTable from "@/pages/ResPage/TurnTable/TurnTable.tsx";
import resStore from "@/store/ResStore.ts";
import { PageCtrl } from "@/core/ctrls/PageCtrl.tsx";
import HomePage from "@/pages/HomePage/HomePage.tsx";
import { dateFormatter } from "@/utils/utils.ts";

@observer
class ResPage extends React.Component<any, any> {

    state = {
        tab: 1,
    }

    async componentDidMount() {
        resStore.updateInfo();
    }

    clickBack = () => {
        PageCtrl.changePage(HomePage);
    }

    changeTab = (tab: number) => {
        this.setState({ tab, });
    }

    clickItem = (item) => {
        if (item.url) {
            location.href = item.url
        } else {
            location.href = `/aaw/projectx/takePrize?projectOrderNo=${item.id}`
        }
    }

    render() {
        const { tab } = this.state;
        const { prizeList, info } = resStore;
        const { titleImg, interval, cycleEndTime, cycleStartTime, profit, remainDrawTime, prizeInfo, amount } = info;

        const tabCls = classNames(styles.tab, {
            [styles.tab1]: tab === 1,
            [styles.tab2]: tab === 2,
        });

        return <div className={styles.ResPage}>
            <div className={styles.bg}/>
            <div className={styles.rankBg}>
                <img className={styles.rankImg} src={titleImg}/>
                <div className={classNames(styles.rankTip, styles.rank1)}>
                    我的收益区间在<span>{interval}</span>
                </div>
                <div className={classNames(styles.rankTip, styles.rank2)}>
                    理财资金<span>{amount/100}元</span>
                </div>
                <div className={classNames(styles.rankTip, styles.rank3)}>
                    累计收益<span>{profit/100}元</span>
                </div>
                <div className={classNames(styles.rankTip, styles.rank4)}>
                    理财周期<span>{dateFormatter(cycleStartTime, `yyyy.MM.dd`)}-{dateFormatter(cycleEndTime, `yyyy.MM.dd`)}</span>
                </div>
            </div>
            <div className={tabCls}>
                <div className={styles.tabBtn1} onClick={() => this.changeTab(1)}/>
                <div className={styles.tabBtn2} onClick={() => this.changeTab(2)}/>
            </div>

            <div style={{ display: tab == 1 ? "block" : "none" }}>
                <TurnTable/>
            </div>

            <div style={{ display: tab == 2 ? "block" : "none" }}>
                {
                    prizeList?.length
                        ? <div className={styles.prizeList} style={{ display: tab == 2 ? "block" : "none" }}>
                            {prizeList?.map((item, index) => {
                                return <div className={styles.prizeItem}>
                                    <img className={styles.itemImg} src={item.extra.icon}/>
                                    <div className={styles.itemName}>{item.extra.name}</div>
                                    <div className={styles.itemDate}>{dateFormatter(item.gmtCreate, "yyyy-MM-dd hh:mm:ss 获得")}</div>
                                    <Button className={styles.itemBtn} onClick={() => this.clickItem(item)}/>
                                </div>
                            })}
                        </div>
                        : <div className={styles.listNone}></div>
                }
            </div>

            <Button className={styles.backBtn} onClick={this.clickBack}/>
        </div>;
    }
}

export default ResPage;
