'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './index.less';
import { ModalCtrl } from '@/core/ctrls/ModalCtrl';
import { Button, Toast } from '@grace/ui';
import { _asyncThrottle, dateFormatter, formatThousand } from '@/utils/utils';
import Countdown from '@/core/components/ComCountdown/index.jsx';
import store from '@/store/store';
/* 电话号码验证规则 **/
export const REG_TEL = /^1[0-9]{10}$/;

@observer
class RedPackCountPanel extends React.Component {
  constructor(props) {
    super(props);
  }

  close = () => {
    ModalCtrl.closeModal()
  }
  getRedCountDown(redRainConfig) {
    const now = new Date().getTime();
    const today = dateFormatter(new Date(), 'yyyy-MM-dd');
    const timeArr = redRainConfig.map(el => {
      return {
        ...el,
        start: new Date(today + " " + el.startTime).getTime(),
        end: new Date(today + " " + el.endTime).getTime(),
      }
    })
    // 按照开始时间排序
    timeArr.sort((a, b) => {
      return a.start - b.start;
    })
    const el = timeArr.find(el => {
      return now >= el.start && now <= el.end;
    })
    if (el && !el.joinStatus) {
      return 0;
    } else {
      const next = timeArr.find(el => {
        return now < el.start;
      });
      if (!next) {
        return 0
      } else {
        return next.start - now
      }
    }
  }
  render() {
    const { redRainConfig } = store.indexData
    const redDownTime = this.getRedCountDown(redRainConfig || []);
    return (<>
      <div className="redPackCountPanel modal_center">
        <span className="bg"></span>
        <div>
          <Countdown
            leftT={redDownTime}
            renderText={data => {
              let { day, hour, minute, second } = data
              let hourNum = Number(day) * 24 + Number(hour);
              hourNum = hourNum >= 10 ? hourNum + "" : '0' + hourNum;
              minute = minute + "";
              second = second + ""
              return <div className="panel_time_box">
                {hourNum.split('').map((el, index) => {
                  return <span className='panel_time_num' key={index}>{el}</span>
                })}
                <span>:</span>
                {minute.split('').map((el, index) => {
                  return <span className='panel_time_num' key={index}>{el}</span>
                })}
                <span>:</span>
                {second.split('').map((el, index) => {
                  return <span className='panel_time_num' key={index}>{el}</span>
                })}
              </div>
            }}
            countdownOver={() => {
              ModalCtrl.closeModal();
              store.updateIndex()
            }}
          />
        </div>
        <Button className="iknow md25" onClick={this.close}></Button>
        <Button className="close" onClick={this.close}></Button>
      </div>
    </>);
  }
}
export default RedPackCountPanel;
