'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './jumpConfirmPop.less';
import store from '../../store/store';
import { Button } from '@grace/ui';
import { _asyncThrottle } from "../../utils/utils";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl";

@observer
class JumpConfirmPop extends React.Component {
  constructor(props) {
    super(props);
  }

  async componentDidMount() {
  }

  handleClose = _asyncThrottle(() => {
    ModalCtrl.closeModal()
  })

  handleConfirm = _asyncThrottle(() => {
    ModalCtrl.closeModal()
    this.props.confirmCb?.()
  })

  render() {
    return (
      <div className="jumpConfirmPop modal_center">
        <span className="bg"></span>
        <div className="text">离开模拟理财功能<br />前往真实理财产品交易页面</div>
        <Button className="think_btn md23" onClick={this.handleClose} />
        <Button className="confirm_btn md24" onClick={this.handleConfirm} />
        <Button className="close" onClick={this.handleClose} />
      </div>
    );
  }
}
export default JumpConfirmPop;
