import UI from "../tools/UI";
import TEXT_ALIGN = FYGE.TEXT_ALIGN;
import Container = FYGE.Container;


/**
 * 纯色进度条
 */
export class ProgressBar extends Container {

	/**
	 * 0到1的进度
	 */
	private _value = 0;
	private upImage: FYGE.Graphics;
	private progressTxt: FYGE.TextField;
	private readonly maxLength: number;

	constructor() {
		super()
		this.maxLength = 377//最大长度
		this._value = 0;
		this.upImage = UI.Graphics(this)
			.beginFill(0xf8c862)
			.drawRoundedRect(0, 0, this.value * this.maxLength, 19, 10)
			.endFill();

		this.progressTxt = UI.Txt(
			this, "0%", 22, "#f8c862",
			TEXT_ALIGN.CENTER, 80, (this.maxLength - 80) / 2, 36
		);

	}

	get value() {
		return this._value;
	}

	set value(v) {
		if (v < 0) v = 0;
		if (v > 1) v = 1;
		this._value = v;
		this.progressTxt.text = ((v * 100) >> 0) + "%";
		const length = this._value * this.maxLength;
		this.upImage.clear()
			.beginFill(0xf8c862)
			.drawRoundedRect(0, 0, length, 19, 10)
			.endFill();
	}
}
