import React from 'react';
import { observer } from 'mobx-react';
import styles from './DetailPage.module.less';
import store from "@/store/store.ts";
import { Button, Toast } from "@grace/ui";
import MyPrize from '../MyPrize/MyPrize';
import { PageCtrl } from '@/core/ctrls/PageCtrl';
import { motion } from "motion/react"
import classNames from "classnames";

enum EOpType {
    Buy = "buy",
    Sell = "sell",
}

@observer
class DetailPage extends React.Component<any, any> {

    state = {
        tabType: EOpType.Buy
    }

    async componentDidMount() {

    }

    clickPrize = () => {
        PageCtrl.changePage(MyPrize);
    }


    clickTab = (type: EOpType) => {
        this.setState({
            tabType: type,
        });
    }

    render() {
        const { tabType } = this.state;

        const testUrl = "https://mobile.hxwm.com.cn/hxlch5/VUE/#/fund-detail-nobuy?fundcode=1912121000101&from=third";

        const isBuy = tabType == EOpType.Buy;

        return <div className={styles.DetailPage}>
            <iframe className={styles.prodIframe} src={testUrl}/>

            <motion.div
                className={styles.options}
                initial={{ height: 570 * remScale }}
                animate={{ height: (isBuy ? 570 : 400) * remScale }}
            >
                <div className={styles.tab}>
                    <div
                        className={styles.tabItem}
                        onClick={() => this.clickTab(EOpType.Buy)}
                    >购买
                    </div>
                    <div
                        className={styles.tabItem}
                        onClick={() => this.clickTab(EOpType.Sell)}
                    >赎回
                    </div>
                    <motion.div
                        className={styles.actBar}
                        animate={{ left: (isBuy ? 61.5 : 436.5) * remScale }}
                    />
                </div>
                <motion.div
                    className={styles.buy}
                    initial={{ x: 0 }}
                    animate={{ x: isBuy ? 0 : 750 * remScale }}
                >
                    <div className={styles.buyInfo}>
                        <div>买入金额</div>
                        <span>可用资金：100000000元</span>
                    </div>
                    <input
                        className={styles.bugInput}
                        placeholder="¥最低买入1.00元"
                    />
                    <div className={styles.buyTip}>首次购买1.00元起 再次购买1.00元起 1.00元递增</div>
                    <Button className={classNames(styles.buyBtn, styles.simulateBuy)}>模拟买入</Button>
                    <Button className={classNames(styles.buyBtn, styles.reallyBuy)}>真实买入</Button>
                </motion.div>
                <motion.div
                    className={styles.sell}
                    initial={{ x: 750 * remScale }}
                    animate={{ x: isBuy ? 750 * remScale : 0 }}
                >
                    <div className={styles.sellInfo}>
                        <div>赎回份额</div>
                        <span>持有份额：0份</span>
                    </div>
                    <div className={styles.sellInput}>
                        <input
                            placeholder="最多可赎回0份"
                        />
                        <Button className={styles.sellAll}>全部</Button>
                    </div>
                    <Button className={classNames(styles.sellBtn, styles.simulateSell)}>模拟赎回</Button>
                </motion.div>
            </motion.div>

        </div>;
    }
}

export default DetailPage;
