
import { RES } from "../../module/RES";
import { getLightBgTexture } from "./getLightBgTexture";

/**
 * 旋转光
 */
export class Light extends FYGE.Sprite {
    constructor() {
        super();
        this.texture = RES.getRes("light.png");
        this.anchorTexture.set(0.5, 0.5);
        this.addEventListener(FYGE.Event.ENTER_FRAME, () => {
            this.rotation += 1;
        }, this)
    }
}

/**
 * 自行生成的光
 */
export class RotateLight extends FYGE.Sprite {
    constructor(
        lightColor: string = "#fffbb0",
        lightRadius: number = 425,
        lightNum: number = 18,
        bgColor: string = lightColor,
        bgRadius: number = lightRadius - 25
    ) {
        super();
        this.texture = getLightBgTexture(
            lightColor,
            lightRadius,
            lightNum,
            bgColor,
            bgRadius
        );
        this.anchorTexture.set(0.5, 0.5);
        this.addEventListener(FYGE.Event.ENTER_FRAME, () => {
            this.rotation += 1;
        }, this)
    }
}