# 开发模版使用文档


### 文件目录
└── template \
    ├── config \
    ├── debug 不要管它 \
    ├── lotties 存放lottie文件 \
    ├── mock mock文件夹 \
    ├── module \
    ├── node_modules \
    ├── released 发布目录 \
    ├── resource 资源目录 \
    ├── scripts 脚本目录 \
    │
    ├── test 测试目录 \
    │   ├── debug 不要管它 \
    │   ├── src 代码目录 \
    │   ├── index.html 代码目录 \
    │   └── rollup.test.mjs \
    │
    ├── src 代码目录 \
    │   ├── index.ts    主要导出 \
    │   ├── Game.ts
    │   ├── ResJson.ts  自动生成 \
    │   └── SkinJson.ts 自动生成 \
    │
    ├── .gitignore \
    ├── index.html html模版 \
    ├── project.json cdn配置 \
    ├── README.md \
    ├── rollup.dev.mjs \
    ├── rollup.prod.mjs \
    └── 开发模版使用文档.md \


## 启动项目
`npm run dev`  
访问 [http://localhost:8080/](http://localhost:8080/)

## 启动测试
`cd test && npm run testDev`  
访问 [http://localhost:8080/test/index.html](http://localhost:8080/test/index.html)


## 打包
`npm run build`  

等待进程结束，在`released`里会出现`index.html`、`output.js`、`output.module.js`

`index.html`可以直接作为web皮肤

`output.js`为umd模块，可在html中直接使用

`output.module.js`为esm模块，可在react、vue等工程里import使用

比如：
```jsx
import React, { Component } from 'react';

import { Game } from "./output.module";

import './GamePage.less';

export default class GamePage extends Component {
	
	div = null;
	game = null;
	
	constructor(props) {
		super(props);
		this.state = {};
	}
	
	componentDidMount() {
		const canvas = document.createElement("canvas");
		canvas.style = "width:100%;height:100%";
		this.div.appendChild(canvas);
		this.game = new Game(canvas);
		this.game.initWebEvent();
	}
	
	componentWillUnmount() {
		this.game.destroy()
	}
	
	render() {
		return <div
			className="game-page"
			ref={(div) => this.div = div}
		/>;
	}
}
```
