import {RES} from "../module/RES";
import {ResJson} from "./ResJson";
import {SkinJson} from "./SkinJson";



export const preloadRes = async (resGroup: string | string[] = "common") => {
    // 初始化资源配置
    RES.loadConfig(ResJson);
    console.log("初始化资源配置完成");

    // 皮肤配置加载
    RES.loadSkinConfig(SkinJson);
    console.log("初始化皮肤配置完成");

    if (typeof resGroup === "string") {
        // 加载通用资源
        await RES.loadGroup(resGroup);
    }else if (Array.isArray(resGroup)) {
        await Promise.all(resGroup.map(res => RES.loadGroup(res)))
    }
    console.log(`资源组${resGroup}加载完成`);
}
