import { makeAutoObservable, } from 'mobx';
import API from "@/api";

class ResStore {

    constructor() {
        makeAutoObservable(this);
    }


    info = {
      titleImg: "",
      interval: "",
      amount: 0,
      profit: 0,
      cycle: "",
      remainDrawTime: 0,
      prizeInfo: [],
    };

    prizeList = [];

    async updatePrizeList() {
        const { success, data } = await API.records({
            ignoreSp: true,
        });
        if (!success) return;
        this.prizeList = data;
    }

    async updateInfo() {
        this.updatePrizeList();
        const { success, data } = await API.drawIndex();
        if (!success) return;
        this.info = data;
    }

}

export default (new ResStore());
