import { generateAPI } from "./utils"

const API = generateAPI({
  /** 获取活动规则 */
  getRule: 'projectRule.query',
  /** 获取前端配置项 */
  getFrontVariable: 'coop_frontVariable.query',
  // getShareInfo: '/wechatShare/getShareInfo/v2',
  getShareInfo: '/wechatMiniApp/ticket/info',
  /** 签到 */
  doSign: {
    uri: 'checkin_1/doSign.do',
    withToken: true,  // 携带token
  },

  // cookie丢失-临时保存cookie
  tempSaveCookie: {
    uri: "/autoLogin/tempSaveCookie",
    showMsg: false,
  },
  // cookie丢失-重新设置cookie
  resetCookie: "/autoLogin/resetCookie",
  userLogin: {
    uri: "userLogin.check",
    showMsg: false,
  },

  // 奖品记录
  records: "records.do",
  // 红包补领
  redpacket: "common/moneyReissue.do",

  getInviteCode: {
    uri: 'inviteAssist_1/getInviteCode.do',
    withToken: true,
    method: 'post',
  },
  doAssist: {
    uri: 'inviteAssist_1/doAssist.do',
    withToken: true,
    method: 'post',
    showMsg: false,
  },

  /** 二维码 */
  getQrcode: "/customActivity/qrcode/getQrcode",
  // 免登-华夏理财
  doAuth: {
    uri: "/customActivity/hxlc/login",
    method: 'post',
    contentType: "json",
  },

  // 首页
  index: "home/index.do",
  // 首页-产品参数更新
  coop_codeUpdate: "home/coop_codeUpdate.do",
  // 首页-白名单限制弹窗
  isWhiteUser: {
    uri: "home/isWhiteUser.do",
    showMsg: false,
  },
  // 首页-查询服务协议
  coop_queryAgreement: "home/coop_queryAgreement.do",
  // 首页-校验验证码并登录
  coop_checkCode: {
    uri: 'home/coop_checkCode.do',
    method: 'post',
  },
  // 首页-发送验证码
  coop_sendCode: {
    uri: 'home/coop_sendCode.do',
    method: 'post',
  },
  // 签到-签到
  doCheckIn: "home/doCheckIn.do",
  // 签到-领奖
  doRewards: "home/doRewards.do",

  tradeRecords: "mncp/tradeRecords.do",
  redeem: "mncp/redeem.do",
  buy: "mncp/buy.do",
  mncpIndex: "mncp/index.do",
  drawIndex: "draw/index.do",
  drawJoin: "draw/join.do",


})

// console.log('======', API)

export default API
