import hxAccountInfo from "hx-account-info";

export function isWeiXin() {
    return /micromessenger/i.test(navigator.userAgent.toLowerCase());
}

/**
 * 判断是否为ios系统
 */
export function isIos() {
  return navigator.userAgent.match(/iphone|ipod|ipad/gi)
}


/** 渠道 */
export const CHANNEL = {
    /** 母行-华夏银行 */
    HXBANK: "1",
    /** 华夏理财 */
    HXLC: "2",
    /** 三方合作APP-南粤银行 */
    NANYUE: "3",
    /** 三方合作APP-紫金 */
    ZIJIN: "4",
    /** 三方合作APP-中信 */
    ZHONGXIN: "5",
    /** 三方合作APP-河北 */
    HEBEI: "6",
    /** 三方合作APP-渤海 */
    BOHAI: "7",
    /** 母行备选渠道 手机号登录模式 投放母行app外 相当于三方合作APP */
    HXBANK_TEL: "8",
    /** 下线弹窗二维码入口进入 */
    OFFLINE_QRCODE: "9",
};

/** 是否为三方合作APP */
export const IS_OTHER_APP = ![CHANNEL.HXBANK, CHANNEL.HXLC].includes(CFG.channel);


/** 跳转行方页面 */
export function jump2AppPage(fundcode) {
    // 有渠道参数1 说明是投放三方(微信公众号) 走新的跳转方法
    if (CFG.channel == '1') {
        window.location.href = `https://mobile.hxwm.com.cn/hxlch5/VUE/#/fund-detail?fundcode=${fundcode}&from=third`
        return
    }

    const navBarStyle = { 'backgroundColor': '#d20a10' }
    // eslint-disable-next-line @spark/best-practices/no-url-in-js
    const target = "gmu://web?startPage=" +
        encodeURIComponent(
            `index.html#/fund-detail?fundcode=${fundcode}&from=third`
        ) +
        `&navBarType=2&navBarStyle=${encodeURIComponent(JSON.stringify(navBarStyle))}`
    console.info('目标地址=================>：', target);
    window.location.href = target
}

/**
 * 获取基金产品详情（app端/微信端）
 * @returns
 */
export function queryAppFundDetail(fund) {
    const fundcode = fund?.fundCode || ''
    console.info('获取基金产品详情 ', fundcode);
    return new Promise(resolve => {
        // app获取
        hxAccountInfo.fundNetWorth({ fundcode }).then((res) => {
            console.info(fundcode, ": fundNetWorth fundcode 请求结果>>>>成功>>>>>>>>>>>>", res);
            const { result } = res || {}
            if (result && Object.keys(result).length > 0) {
                resolve({
                    fundcode: result.fundcode || fundcode, // app文档中没有返回fundcode字段 自己兜底存一下
                    fundCode: result.fundcode || fundcode, // app文档中没有返回fundcode字段 自己兜底存一下
                    newDate: result.newDate, // 当前日期
                    totalnetValue: result.totalnetvalue, // 累计净值
                    pernetValue: result.pernetvalue, // 单位净值
                    incomeRate: fund?.productType == 1 ? result.incomeRate : result.incomeRateO, // 收益率
                    incomeRateName: fund?.productType == 1 ? result.incomeRateName : result.incomeRateNameO, // 收益率名称
                    path: result.path, // 产品详情地址
                })
            } else {
                resolve(false)
            }
        }).catch(err => {
            console.info(fundcode, ": fundNetWorth fundcode 请求结果>>>>失败>>>>>>>>>>>>", err);
            resolve(false)
        })
    })
}

// 判断jsbridge加载完成
function ready(callback) {
    if (window.AlipayJSBridge) {
        callback && callback();
    } else {
        document.addEventListener("AlipayJSBridgeReady", callback, false);
    }
}

function bfSearchMenu(param, callback) {
    window.AlipayJSBridge.call('BFSearchMenuHandler', {
        param: param,
    }, callback)
}

/** 行方跳转方法-华夏银行 */
export function appJump(url) {
    console.info("bfSearchMenu url", url)
    // 判断端内，若在端内走回调
    ready(() => {
        // 跳转的路径，视具体修改
        bfSearchMenu({
            url
        })
    })
}


/** 跳转方法 区分app */
export function diffJump(url) {
    if (CFG.channel == CHANNEL.BOHAI) { // 渤海银行
        boHaiAppJump(url)
    } else if (CFG.channel == CHANNEL.HXLC) { // 华夏理财
        hxlcAppJump(url)
    } else if (CFG.channel == CHANNEL.HXBANK) { // 华夏银行
        appJump(url)
    } else if (IS_OTHER_APP) { // 其他三方app
        location.href = url
    }
}
