import { Module } from "./Module";

export class Panel extends Module {

    protected isShowing: boolean

    showAni() {
        if (this.isShowing) return;
        this.isShowing = true;
        let oriY = this.y || 0;
        this.y = -200;
        FYGE.Tween.get(this)
            .to({y: oriY}, 500, FYGE.Ease.quartOut)
            .call(() => {
                this.isShowing = false;
            })
    }

    initEvents() {
        this.closeBtns.forEach(
            btn => {
                if (btn) btn.addEventListener(FYGE.MouseEvent.CLICK, this.hidePanel, this)
            }
        )
    }

    removeEvents() {
        this.closeBtns.forEach(
            btn => {
                if (btn) btn.removeEventListener(FYGE.MouseEvent.CLICK, this.hidePanel, this)
            }
        )
    }

    /**
     * 需要的放入，不重复写关闭按钮事件
     */
    protected get closeBtns(): any[] {
        return [this['closeBtn']]
    }

    hidePanel() {
        this.destroy();
    }
}
