'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './privacypop.less';
import { ModalCtrl } from '@/core/ctrls/ModalCtrl';
import { Button } from '@grace/ui';

@observer
class Privacypop extends React.Component {
  constructor(props) {
    super(props);
  }

  close = () => {
    const { closeCb } = this.props;
    // 组件形式使用
    if (closeCb) {
      closeCb()
    } else {
      ModalCtrl.closeModal()
    }
  }

  render() {
    const { agreementText } = this.props || {}
    return (
      <div className="privacypop modal_center">
        <span className="light"></span>
        <span className="bg"></span>
        <span className="title">个人信息收集声明</span>
        <div className="text" dangerouslySetInnerHTML={{ __html: agreementText }}></div>
        <Button className="close" onClick={this.close}></Button>
      </div>
    );
  }
}
export default Privacypop;
