import { CHANNEL } from "@/AppTools";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl";
import Loginpop from "@/panels/loginpop/loginpop";
import { Toast } from "@grace/ui";

// 需要过滤的错误码
export const filterCode = ["600002"];

export const errMessageMap = {
  1020: "活动未开始",
  1021: "活动已结束",
  1007: "活动太火爆了，奖品已抢完咯～",
  100001: "登录过期啦，请重新登录哦～",
  200306: "助力失败，不能给自己助力哦～",
  200303: '助力机会已用完，一起来参与活动吧～',
  200304: "好友今日任务已完成，明天再来助力吧～",
  200305: "已为好友助力哦～",
  20002: "活动已结束，感谢您的关注～"
};

/**
 * 统一错误处理
 * @param e
 */
export function errorHandler(error) {
  if ((error.code == 0 && error.message == "请稍后再试") || filterCode.indexOf(`${error.code}`) >= 0) return;
  // 三方合作APP/华夏理财app 未登录时 除首页接口外 其他接口都走登录弹窗
  if (CFG.channel != CHANNEL.HXBANK && (error.code == 100001 || error.code == 100007 || error.code == 100009)) return ModalCtrl.showModal(Loginpop);
  switch (error.code) {
    default: {
      const msg = errMessageMap[error.code] || error.message || '网络异常，请稍后再试';
      Toast.show(msg);
      break;
    }
  }
}
