/*
 * index.mjs
 * Created by 还有醋v on 2022/5/27.
 * Copyright © 2022 haiyoucuv. All rights reserved.
 */

/**
 * 插入banner变量
 * @param {{values:{[key in string]: string|number|Function<string|number>}}} options
 */
export default function pluginBannerVariable(options) {
	
	const { values } = options;
	
	return {
		name: "banner-variable",
		banner() {
			let code = "var ";
			for (const key in values) {
				const value = values[key] instanceof Function ? values[key]() : values[key];
				code += `${key}=${value},`;
			}
			code = code.slice(0, code.length - 1) + ";";
			return code;
		},
	}
}
