/*
 * GamePage.jsx
 * Created by 还有醋v on 2022/6/6.
 * Copyright © 2022 haiyoucuv. All rights reserved.
 */


import React, { Component } from 'react';

import { Game, setConfig, GDispatcher, GAME_EVENT, preloadRes } from "../../../debug/output.module";

import './GamePage.less';

export default class GamePage extends Component {
	
	canvas = React.createRef();
	game = null;
	
	async componentDidMount() {

		// 作为模块使用预加载资源
		await preloadRes('game');

		this.game = new Game(this.canvas.current);
		
		// 注册触摸事件
		this.game.initWebEvent();
		
		// 设置参数
		setConfig({
			dropSpeed: 400,
			interval: 1,
		});
		
		// 等待READY事件表示可以开始游戏
		GDispatcher.once(GAME_EVENT.READY, () => {

		});

	}

	componentWillUnmount() {
		this.game.destroy();
	}

	handleStartGame = () => {
		// 触发开始游戏事件
		GDispatcher.dispatchEvent(GAME_EVENT.START_GAME);
	}
	
	render() {
		return <div
			className="game-page"
			ref={(div) => this.div = div}
		>
			<button onClick={this.handleStartGame}>开始游戏</button>
			<canvas ref={this.canvas} style={{width:'100%',height:'100%'}} />
		</div>
	}
}
