import { generateAPI } from "./utils"

const API = generateAPI({
  /** 获取活动规则 */
  getRule: 'projectRule.query',
  /** 获取前端配置项 */
  getFrontVariable: 'coop_frontVariable.query',
  // getShareInfo: '/wechatShare/getShareInfo/v2',
  getShareInfo: '/wechatMiniApp/ticket/info',

  // cookie丢失-临时保存cookie
  tempSaveCookie: {
    uri: "/autoLogin/tempSaveCookie",
    showMsg: false,
  },
  // cookie丢失-重新设置cookie
  resetCookie: "/autoLogin/resetCookie",
  userLogin: {
    uri: "userLogin.check",
    showMsg: false,
  },

  // 奖品记录
  records: "draw/myRucksack.do",
  // 红包补领
  redpacket: "common/moneyReissue.do",

  getInviteCode: {
    uri: 'inviteAssist_1/getInviteCode.do',
    withToken: true,
    method: 'post',
  },
  doAssist: {
    uri: 'inviteAssist_1/doAssist.do',
    withToken: true,
    method: 'post',
    showMsg: false,
  },

  /** 二维码 */
  getQrcode: "/customActivity/qrcode/getQrcode",
  // 免登-华夏理财
  doAuth: {
    uri: "/customActivity/hxlc/login",
    method: 'post',
    headers: {
      'Content-Type': 'application/json',
    },
  },

  // 首页
  index: "home/index.do",
  // 首页-产品参数更新
  coop_codeUpdate: {
    uri: "home/coop_codeUpdate.do",
    method: 'post',
    headers: {
      'Content-Type': 'application/json',
    },
  },
  // 首页-白名单限制弹窗
  isWhiteUser: {
    uri: "home/isWhiteUser.do",
    showMsg: false,
  },
  // 首页-查询服务协议
  coop_queryAgreement: "home/coop_queryAgreement.do",
  // 首页-校验验证码并登录（渠道5-昆仑银行使用）
  coop_checkCode: {
    uri: 'home/coop_checkCode.do',
    method: 'post',
  },
  // 首页-校验验证码并登录（渠道1-华夏理财，渠道2-华夏银行使用）
  checkCode: {
    uri: 'home/checkCode.do',
    method: 'post',
  },
  // 首页-发送验证码
  coop_sendCode: {
    uri: 'home/coop_sendCode.do',
    method: 'post',
  },
  // 签到-签到
  doCheckIn: "home/doCheckIn.do",
  // 签到-领奖
  doRewards: "home/doRewards.do",

  tradeRecords: "mncp/tradeRecords.do",
  queryWealthRecords: "home/queryWealthRecords.do",

  redeem: "mncp/redeem.do",
  buy: "mncp/buy.do",
  mncpIndex: "mncp/index.do",
  drawIndex: "draw/index.do",
  drawJoin: "draw/join.do",

  // 新人礼抽奖
  newbieDraw: `home/tradeDraw.do`,

  // 红包雨开始游戏
  redStartGame: `redRain/startGame.do`,

  // 红包雨提交
  redSubmitGame: `redRain/submitGame.do`,

  /** 分享落地页接口 */
  getSharePageInfo: "invite/coop_queryRecommand.do",

  // 获取任务列表的接口
  getTaskList: "task/queryTasks.do",
  // 完成任务接口
  completeTask: "task/doCompleted.do",
  // 任务领奖接口
  sendPrizeTask: "task/sendPrize.do",

  // 查询题目
  queryQS: "answer_1/query.do",

  // 开始答题
  startQS: {
    uri: "answer_1/start.do",
    method: 'post',
    withToken: true,
  },
  // 获取题目
  getQS: {
    uri: "answer_1/getQuestion.do",
    method: 'post',
    withToken: true,
  },
  // 提交题目
  submitQS: {
    uri: "answer_1/submit.do",
    method: 'post',
    withToken: true,
  },
  // 完成答题
  completeQS: {
    uri: "answer_1/doCompleted.do",
    method: 'post',
    withToken: true,
  },

  doAsistInSharePage: {
    uri: "invite/coop_assist.do",
  },

  queryInviteCode: {
    uri: 'invite/queryInviteCode.do',
    withToken: true,
  }

})

// console.log('======', API)

export default API
