import hxAccountInfo from "hx-account-info";

export function isWeiXin() {
    return /micromessenger/i.test(navigator.userAgent.toLowerCase());
}

/**
 * 判断是否为ios系统
 */
export function isIos() {
    return navigator.userAgent.match(/iphone|ipod|ipad/gi)
}

/** 产品类型 */
export const PRODUCT_TYPE = {
    /** 非现金 */
    NON_CASH: 0,
    /** 现金 */
    CASH: 1,
}

/** 产品收益率名称 */
export const RATE_NAME = {
    /** 非现金 */
    [PRODUCT_TYPE.NON_CASH]: '成立以来年化收益率',
    /** 现金 */
    [PRODUCT_TYPE.CASH]: '七日年化收益率',
}

/** 渠道 */
export const CHANNEL = {
    /** 华夏理财 */
    HXLC: "1",
    /** 母行-华夏银行 */
    HXBANK: "2",
    /** 渠道5-昆仑银行 */
    KUNLUN: "5",
};

/** 是否为三方合作APP */
export const IS_OTHER_APP = ![CHANNEL.HXBANK, CHANNEL.HXLC].includes(CFG.channel);


/** ========== 华夏银行APP 华夏理财APP 端内方法 start =========== */
/**
 * 获取基金产品详情（app端/微信端）
 * @returns
 */
export function queryAppFundDetail(fund) {
    const fundcode = fund?.code || ''
    console.info('获取基金产品详情 ', fundcode);
    return new Promise(resolve => {
        // app获取
        hxAccountInfo.fundNetWorth({ fundcode }).then((res) => {
            console.info(fundcode, ": fundNetWorth fundcode 请求结果>>>>成功>>>>>>>>>>>>", res);
            console.info(fundcode, ": fundNetWorth fundcode 请求结果>>>>成功result>>>>>>>>>>>>", res.result);
            const { result } = res || {}
            if (result && Object.keys(result).length > 0) {
                resolve({
                    fundcode: result.fundcode || fundcode, // app文档中没有返回fundcode字段 自己兜底存一下
                    fundCode: result.fundcode || fundcode, // app文档中没有返回fundcode字段 自己兜底存一下
                    newDate: result.newDate, // 当前日期
                    totalnetValue: result.totalnetvalue, // 累计净值
                    pernetValue: result.pernetvalue, // 单位净值
                    incomeRate: fund?.type == PRODUCT_TYPE.CASH ? result.incomeRate : result.incomeRateO, // 收益率
                    incomeRateName: fund?.type == PRODUCT_TYPE.CASH ? result.incomeRateName : result.incomeRateNameO, // 收益率名称
                    path: result.path, // 产品详情地址
                })
            } else {
                resolve(false)
            }
        }).catch(err => {
            console.info(fundcode, ": fundNetWorth fundcode 请求结果>>>>失败>>>>>>>>>>>>", err);
            resolve(false)
        })
    })
}

// 判断jsbridge加载完成
function ready(callback) {
    if (AlipayJSBridge) {
        callback && callback();
    } else {
        document.addEventListener("AlipayJSBridgeReady", callback, false);
    }
}

function bfSearchMenu(param, callback?: any) {
    AlipayJSBridge.call('BFSearchMenuHandler', {
        param: param,
    }, callback)
}

/** 行方跳转方法-华夏银行 */
export function appJump(url) {
    console.info("bfSearchMenu url", url)
    // 判断端内，若在端内走回调
    ready(() => {
        // 跳转的路径，视具体修改
        bfSearchMenu({
            url
        })
    })
}


/** 跳转行方页面-华夏理财 */
export function hxlcAppJump(fundcode) {
    const navBarStyle = { 'backgroundColor': '#d20a10' }
    const target = "gmu://web?startPage=" +
        encodeURIComponent(
            `index.html#/fund-detail?fundcode=${fundcode}&from=third`
        ) +
        `&navBarType=2&navBarStyle=${encodeURIComponent(JSON.stringify(navBarStyle))}`
    console.info('目标地址=================>：', target);
    window.location.href = target
}

/** ========== 华夏银行APP 华夏理财APP 端内方法 end =========== */

/** 跳转方法 区分app */
export function diffJump(url) {
    if (CFG.channel == CHANNEL.HXLC) { // 华夏理财
        hxlcAppJump(url)
        
    } else if (CFG.channel == CHANNEL.HXBANK) { // 华夏银行   
        // appJump(url)
        // 浦发跳转
        (window as any).$spdbApi.go({
            target: url,
         });

    } else { // 其他三方app
        location.href = url
    }
}
