'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './invalidPop.less';
import store from '../../store/store';
import { Button } from '@grace/ui';
import { _asyncThrottle } from "../../utils/utils";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl";
import { Toast } from '@grace/ui';

@observer
class InvalidPop extends React.Component {
  constructor(props) {
    super(props);
  }

  async componentDidMount() {
    store.initRule();
  }

  handleClose = _asyncThrottle(() => {
    Toast.show('请退出活动哦~');
    // ModalCtrl.closeModal()
  })

  render() {
    return (
      <div className="invalidPop modal_center">
        <span className="bg"></span>
        <div className="text">本次活动适用于零基础投资者<br />感谢您对本次模拟理财大赛的关注</div>
        <Button className="know_btn" onClick={this.handleClose} />
        {/* <Button className="close" onClick={this.handleClose} /> */}
      </div>
    );
  }
}
export default InvalidPop;
