import React from 'react';
import { observer } from 'mobx-react';
import styles from './ResPage.module.less';
import { Button } from "@grace/ui";
import classNames from "classnames";
import TurnTable from "@/pages/ResPage/TurnTable/TurnTable.tsx";
import resStore from "@/store/ResStore.ts";

@observer
class ResPage extends React.Component<any, any> {

    state = {
        tab: 1,
    }

    async componentDidMount() {
        resStore.updateInfo();
    }

    clickBack = () => {

    }

    changeTab = (tab: number) => {
        this.setState({ tab, });
    }


    render() {
        const { tab } = this.state;
        const { titleImg, interval, cycle, profit, remainDrawTime, prizeInfo, amount } = resStore.info;

        const tabCls = classNames(styles.tab, {
            [styles.tab1]: tab === 1,
            [styles.tab2]: tab === 2,
        });

        return <div className={styles.ResPage}>
            <div className={styles.bg}/>
            <div className={styles.rankBg}>
                <img className={styles.rankImg} src={titleImg}/>
                <div className={classNames(styles.rankTip, styles.rank1)}>
                    我的收益区间在<span>{interval}</span>
                </div>
                <div className={classNames(styles.rankTip, styles.rank2)}>
                    理财资金<span>{amount/100}元</span>
                </div>
                <div className={classNames(styles.rankTip, styles.rank3)}>
                    累计收益<span>{profit/100}元</span>
                </div>
                <div className={classNames(styles.rankTip, styles.rank4)}>
                    理财周期<span>{cycle}</span>
                </div>
            </div>
            <div className={tabCls}>
                <div className={styles.tabBtn1} onClick={() => this.changeTab(1)}/>
                <div className={styles.tabBtn2} onClick={() => this.changeTab(2)}/>
            </div>

            <div style={{ display: tab == 1 ? "block" : "none" }}>
                <TurnTable/>
            </div>

            <div style={{ display: tab == 2 ? "block" : "none" }}>
                <div className={styles.listNone}></div>
                <div className={styles.prizeList} style={{ display: tab == 2 ? "block" : "none" }}>
                    {new Array(100).fill(1).map((_, index) => {
                        return <div className={styles.prizeItem}>
                            <img className={styles.itemImg}/>
                            <div className={styles.itemName}>奖品名称</div>
                            <div className={styles.itemDate}>2024-09-22 00:02:56 获得</div>
                            <Button className={styles.itemBtn}/>
                        </div>
                    })}
                </div>
            </div>

            <Button className={styles.backBtn} onClick={this.clickBack}/>
        </div>;
    }
}

export default ResPage;
