/*
 * RainMgr.ts
 * Created by 还有醋v on 2022/6/1.
 * Copyright © 2022 haiyoucuv. All rights reserved.
 */

import Container = FYGE.Container;
import gameConfig from "../Config";
import UI from "../tools/UI";
import Sprite = FYGE.Sprite;
import MouseEvent = FYGE.MouseEvent;
import {GameScene} from "./GameScene";
import {GAME_EVENT, GDispatcher} from "../index";
import {getCurrentScene} from "../../module/ctrls";

export default class RainObj extends Container {

	static _pool: RainObj[] = [];

	static get(): RainObj {
		return this._pool.splice(0, 1)[0] || new RainObj();
	}

	static put(obj: RainObj) {
		return this._pool.push(obj);
	}

	private image: Sprite = null;

	constructor() {
		super();
		this.init();
	}

	getRandomNumber(min: number, max: number): number {
        return Math.random() * (max - min) + min;
    }

	reset() {
		const { width, height } = this.image;
		const x = width / 2 + Math.random() * (750 - width);
		const y = this.getRandomNumber(-Math.random() * 400 - height, -height)
		this.position.set(x, y);
		// this.rotation = Math.random() * 50 + 10;
	}

	init() {
		const sp = gameConfig.rainObj[Math.random() * gameConfig.rainObj.length >> 0];
		this.name = sp;
		this.image = UI.Sp(this, sp);
		this.image.anchorTexture.set(0.5, 0.5);

		// remove
		this.addEventListener(MouseEvent.MOUSE_DOWN, (e) => {
			(getCurrentScene() as GameScene).removeObj(this);
			(getCurrentScene() as GameScene).addEffect(this.x, this.y, this.name);
			GDispatcher.dispatchEvent(GAME_EVENT.ADD_SCORE, {type: 'redBag'})
		});
	}
}
