import React from 'react';
import { observer } from 'mobx-react';
import './TurnTable.less';
import { CircleTurntable } from "@spark/circle-turntable";
// import turnTableStore from "@src/store/TurnTableStore";
import { Button, Toast } from "@grace/ui";
import { _asyncThrottle } from "@/utils/utils.ts";

@observer
class TurnTable extends React.Component {

    turntableRef = null; // 大转盘
    btnStarting = false; // 转盘是否启动
    drawResultInfo = {};

    async componentDidMount() {
        // await store.getDrawInfo();
    }

    onStop = () => {
        this.btnStarting = false;
        // turnTableStore.updateInfo();
        // modalStore.pushPop("PrizePanel", this.drawResultInfo);
    }

    // 开始抽奖
    drawHandle = _asyncThrottle(async () => {
        if (this.btnStarting) return false;
        this.btnStarting = true;

        // modalStore.pushPop("CheckPanel", {
        //   text: `您将消耗${drawConsumeOil}加油值进行抽奖哦`,
        //   ok: async () => {
        //     const { success, data } = await API.dbgjDraw();
        //     if (!success) {
        //       turnTableStore.updateInfo();
        //       return;
        //     }
        //
        //     // 转盘转动开始抽奖
        //     this.turntableRef.launch();
        //     this.drawResultInfo = data;
        //
        //     const index = turnTableStore.info.prizeInfo?.findIndex((item) => item.prizeId === this.drawResultInfo.prizeId);
        //     this.turntableRef.braking(index);
        //   },
        //   cancel: () => {
        //     this.btnStarting = false;
        //   },
        // });

    });


    render() {
        // const { drawConsumeOil, prizeInfo } = turnTableStore.info;

        return <div className="TurnTable">
            <CircleTurntable
                className="tt_box"
                ref={(ref) => (this.turntableRef = ref)}
                options={new Array(6).fill({ prizeName: 123 })}
                angleOffset={180 / 6 + 10} // 角度偏移量
                radian={100} // 奖项半径
                launchDuration={1000} // 启动时间
                // 大转盘背景
                renderBackground={<div className="turntable_bg"></div>}
                // 大转盘指针
                renderStartButton={<div className="ttBtn"/>}
                // 渲染奖品信息
                renderOption={(option) => {
                    return <div className="prize_item">
                        <div className="prize_name">{option.prizeName}</div>
                        <img className="prize_img" src={option.prizeImg} alt=""/>
                    </div>;
                }}
                didStop={this.onStop}
            />
            <Button className="drawBtn" onClick={this.drawHandle}/>
        </div>;
    }
}

export default TurnTable;
